<?php
namespace App\Helpers;

use ClickHouseDB\Client;

class ClickHouseHelper
{
    private $client;

    public function __construct()
    {
        $this->client = new Client([
            'host'     => env('CLICKHOUSE_HOST', '36.66.227.210'),
            'port'     => env('CLICKHOUSE_PORT', 8123),
            'username' => env('CLICKHOUSE_USERNAME', 'default'),
            'password' => env('CLICKHOUSE_PASSWORD', ''),
        ]);

        $this->client->database(env('CLICKHOUSE_DATABASE', 'cctv_uidkalbar'));
        $this->client->setTimeout(10); // Timeout dalam detik
        $this->client->setConnectTimeOut(connectTimeOut: 10);
    }

    public function query($sql)
    {
        return $this->client->select($sql)->rows();
    }
}