<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CCTVAreaModel;

class CctvAreaController extends Controller
{
    public function index(Request $request)
    {
        try {
            // Dapatkan parameter pagination
            $itemsPerPage = $request->get('itemsPerPage', 10); // Default 10 item per halaman
            $search = $request->get('search', '');

            // Query dengan pencarian dan pagination
            $areas = CCTVAreaModel::where('area_name', 'like', "%{$search}%")
                ->orderBy('created_at', 'desc')
                ->paginate($itemsPerPage);

            return response()->json($areas, 200);
        } catch (\Exception $e) {
            return response()->json(['message' => 'Error fetching CCTV Areas.', 'error' => $e->getMessage()], 500);
        }
    }

    public function store(Request $request)
    {
        $request->validate([
            'area_name' => 'required|string|max:255',
            'status' => 'required|boolean',
        ]);

        try {
            $area = CCTVAreaModel::create($request->all());
            return response()->json($area, 201);
        } catch (\Exception $e) {
            return response()->json(['message' => 'Error creating CCTV Area.', 'error' => $e->getMessage()], 500);
        }
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'area_name' => 'required|string|max:255',
            'status' => 'required|boolean',
        ]);

        try {
            $area = CCTVAreaModel::findOrFail($id);
            $area->update($request->all());
            return response()->json($area, 200);
        } catch (\Exception $e) {
            return response()->json(['message' => 'Error updating CCTV Area.', 'error' => $e->getMessage()], 500);
        }
    }

    public function destroy($id)
    {
        try {
            $area = CCTVAreaModel::findOrFail($id);
            $area->delete();
            return response()->json(['message' => 'CCTV Area deleted successfully.'], 200);
        } catch (\Exception $e) {
            return response()->json(['message' => 'Error deleting CCTV Area.', 'error' => $e->getMessage()], 500);
        }
    }
}