<?php
namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\BuildingModel;
use App\Models\CCTVAreaModel;
use App\Models\CCTVModel;
use App\Models\OfficeModel;
use App\Models\PlateNumberModel;
use App\Models\UserModel;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function getCounts(Request $request)
    {
        try {
            $usersCount          = UserModel::where('status', '1')->count();
            $superadminCount     = UserModel::where('level_id', '2')->where('status', '1')->count();
            $managerCount        = UserModel::where('level_id', '3')->where('status', '1')->count();
            $securityCount       = UserModel::where('level_id', '4')->where('status', '1')->count();
            $employeeCount       = UserModel::where('level_id', '5')->where('status', '1')->count();
            $visitorCount        = UserModel::where('level_id', '6')->where('status', '1')->count();
            $generalManagerCount = UserModel::where('level_id', '7')->where('status', '1')->count();
            $asmanCount          = UserModel::where('level_id', '8')->where('status', '1')->count();
            $teamLeaderCount     = UserModel::where('level_id', '9')->where('status', '1')->count();
            $tadCount            = UserModel::where('level_id', '10')->where('status', '1')->count();
            $cctvCount           = CCTVModel::where('status', '1')->count();
            $cctvAreaCount       = CCTVAreaModel::where('status', '1')->count();
            $buildingCount       = BuildingModel::where('status', '1')->count();
            $plateNumberCount    = PlateNumberModel::where('status', '1')->count();
            $officeCount         = OfficeModel::where('status', '1')->count();

            return response()->json([
                'usersCount'          => $usersCount,
                'superadminCount'     => $superadminCount,
                'generalManagerCount' => $generalManagerCount,
                'managerCount'        => $managerCount,
                'asmanCount'          => $asmanCount,
                'teamLeaderCount'     => $teamLeaderCount,
                'employeeCount'       => $employeeCount,
                'tadCount'            => $tadCount,
                'securityCount'       => $securityCount,
                'visitorCount'        => $visitorCount,
                'cctvCount'           => $cctvCount,
                'cctvAreaCount'       => $cctvAreaCount,
                'buildingCount'       => $buildingCount,
                'plateNumberCount'    => $plateNumberCount,
                'officeCount'         => $officeCount,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Error fetching dashboard data !',
                'error'   => $e->getMessage(),
            ], 500);
        }
    }
}