<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BuildingModel extends Model
{
    use HasFactory;

    protected $table = 'tbl_building';

    protected $fillable = [
        'office_id',
        'building_name',
        'address',
        'status',
    ];

    public $timestamps = true; // Ensure timestamps are handled automatically

    public function cctvs()
    {
        return $this->hasMany(CCTVModel::class, 'building_id');
    }
    public function office()
    {
        return $this->belongsTo(OfficeModel::class, 'office_id', 'id'); // Pastikan kolom foreign key sesuai
    }
}
