<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CCTVAccessModel extends Model
{
    use HasFactory;

    protected $table = 'tbl_cctv_access';
    protected $fillable = ['level_id', 'cctv_id'];

    public $timestamps = true; // Auto handles created_at and updated_at

    public function userLevel()
    {
        return $this->belongsTo(UserLevelModel::class, 'level_id');
    }

    public function cctv()
    {
        return $this->belongsTo(CCTVModel::class, 'cctv_id');
    }
}