<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CCTVLogModel extends Model
{
    use HasFactory;

    protected $table = 'tbl_cctv_log';
    protected $fillable = ['cctv_id', 'user_id', 'log_type', 'detected_time'];

    public $timestamps = true; // Auto handles created_at and updated_at

    public function cctv()
    {
        return $this->belongsTo(CCTVModel::class, 'cctv_id');
    }

    public function user()
    {
        return $this->belongsTo(UserModel::class, 'user_id');
    }
}