<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CCTVModel extends Model
{
    use HasFactory;

    protected $table = 'tbl_cctv';
    protected $fillable = [
        'camera_id',
        'camera_name',
        'ip_address',
        'ip_address_intranet',
        'resolution',
        'building_id',
        'status'
    ];


    public $timestamps = true;

    public function building()
    {
        return $this->belongsTo(BuildingModel::class, 'building_id');
    }
}