<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DetectionLogModel extends Model
{
    use HasFactory;

    protected $table = 'tbl_detection_logs';

    // Field yang dapat diisi
    protected $fillable = [
        'user_id',
        'camera_id',
        'datetime',
    ];

    /**
     * Relasi ke model User.
     * Menghubungkan `user_id` dengan tabel `tbl_user`.
     */
    public function user()
    {
        return $this->belongsTo(UserModel::class, 'user_id');
    }

    /**
     * Relasi ke model CCTV.
     * Menghubungkan `camera_id` dengan tabel `tbl_cctv`.
     */
    public function camera()
    {
        return $this->belongsTo(CCTVModel::class, 'camera_id');
    }
}