<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GateAccessModel extends Model
{
    use HasFactory;

    protected $table = 'tbl_gate_access';
    protected $fillable = ['user_id', 'access_type', 'access_time'];

    public $timestamps = true; // Auto handles created_at and updated_at

    public function user()
    {
        return $this->belongsTo(UserModel::class, 'user_id');
    }
}