<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotificationModel extends Model
{
    use HasFactory;

    protected $table = 'tbl_notifications';
    protected $fillable = ['user_id', 'message', 'status'];

    public $timestamps = true; // Auto handles created_at and updated_at

    public function user()
    {
        return $this->belongsTo(UserModel::class, 'user_id');
    }
}