<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OfficeModel extends Model
{
    use HasFactory;

    protected $table = 'tbl_office'; // Nama tabel di database

    protected $fillable = [
        'office_name',
        'office_short_name',
        'address',
        'description',
        'latitude',
        'longitude',
        'status',
    ];

    public $timestamps = true; // Ensure timestamps are handled automatically

    /**
     * Relasi ke tabel User (One-to-Many).
     */
    public function users()
    {
        return $this->hasMany(UserModel::class, 'office_id');
    }

    public function buildings()
    {
        return $this->hasMany(BuildingModel::class, 'office_id', 'id');
    }
}
