<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PlateNumberModel extends Model
{
    use HasFactory;

    protected $table    = 'tbl_plate_number';
    protected $fillable = [
        'user_id',
        'plate_number',
        'status',
    ];

    public $timestamps = true;

    // Define relationship to UserModel
    public function user()
    {
        return $this->belongsTo(UserModel::class, 'user_id', 'id');
    }
}
