<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PresenceModel extends Model
{
    use HasFactory;

    protected $table = 'tbl_presence';
    protected $fillable = [
        'user_id',
        'check_in',
        'check_out',
        'duration',
        'visit_type'
    ];

    public $timestamps = true; // Auto handles created_at and updated_at

    public function user()
    {
        return $this->belongsTo(UserModel::class, 'user_id');
    }
}