<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserLevelModel extends Model
{
    use HasFactory;

    protected $table = 'tbl_user_level';
    protected $fillable = ['level_name', 'status'];

    public $timestamps = true; // This ensures created_at and updated_at are auto-filled

    public function users()
    {
        return $this->hasMany(UserModel::class, 'level_id');
    }
}