<?php
namespace App\Models;

use Illuminate\Auth\Authenticatable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Tymon\JWTAuth\Contracts\JWTSubject;

class UserModel extends Model implements AuthenticatableContract, JWTSubject
{
    use HasFactory, Authenticatable;

    protected $table    = 'tbl_user';
    protected $fillable = [
        'level_id',
        'office_id',
        'ai_label',
        'username',
        'nama_lengkap',
        'email',
        'no_hp',
        'password',
        'nip',
        'jabatan',
        'token_reset_password',
        'token_login',
        'last_login',
        'status',
    ];

    public $timestamps = true;

    protected $hidden = [
        'password',
        'token_reset_password',
    ];

    protected $casts = [
        'last_login' => 'datetime',
    ];

    public function userLevel()
    {
        return $this->belongsTo(UserLevelModel::class, 'level_id');
    }

    public function office()
    {
        return $this->belongsTo(OfficeModel::class, 'office_id', 'id'); // Pastikan foreign key sesuai
    }

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
}