<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VisitHoursModel extends Model
{
    use HasFactory;

    protected $table = 'tbl_visit_hours';
    protected $fillable = ['level_id', 'start_time', 'end_time', 'status'];

    public $timestamps = true; // Auto handles created_at and updated_at

    public function userLevel()
    {
        return $this->belongsTo(UserLevelModel::class, 'level_id');
    }
}