<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblUserTable extends Migration
{
    public function up()
    {
        Schema::create('tbl_user', function (Blueprint $table) {
            $table->id();
            $table->foreignId('level_id')->constrained('tbl_user_level')->onDelete('cascade');
            $table->string('username')->unique();
            $table->string('email')->unique();
            $table->string('no_hp')->nullable(); // Phone number (optional)
            $table->string('password'); // User password
            $table->string('nip')->nullable(); // Nomor Induk Pegawai (optional)
            $table->string('jabatan')->nullable(); // Job position (optional)
            $table->string('token_reset_password')->nullable(); // Password reset token (optional)
            $table->timestamp('last_login')->nullable(); // Last login time (optional)
            $table->enum('status', [0, 1])->default(1); // 0: Inactive, 1: Active
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tbl_user');
    }
}