<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblCCTVTable extends Migration
{
    public function up()
    {
        Schema::create('tbl_cctv', function (Blueprint $table) {
            $table->id();
            $table->string('camera_name');
            $table->string('ip_address')->unique();
            $table->string('resolution')->nullable();
            $table->foreignId('building_id')->constrained('tbl_building')->onDelete('cascade');
            $table->enum('status', [0, 1])->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tbl_cctv');
    }
}