<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblPresenceTable extends Migration
{
    public function up()
    {
        Schema::create('tbl_presence', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('tbl_user')->onDelete('cascade'); // Foreign key to tbl_user
            $table->dateTime('entry_time');
            $table->dateTime('exit_time')->nullable();
            $table->integer('duration')->nullable(); // In minutes
            $table->string('visit_type'); // pegawai or tamu
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tbl_presence');
    }
}