<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblVisitHoursTable extends Migration
{
    public function up()
    {
        Schema::create('tbl_visit_hours', function (Blueprint $table) {
            $table->id();
            $table->foreignId('level_id')->constrained('tbl_user_level')->onDelete('cascade'); // Foreign key to tbl_user_level
            $table->time('start_time');
            $table->time('end_time');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tbl_visit_hours');
    }
}