<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblNotificationsTable extends Migration
{
    public function up()
    {
        Schema::create('tbl_notifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('tbl_user')->onDelete('cascade');
            $table->string('message');
            $table->boolean('read')->default(false); // Read/unread
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tbl_notifications');
    }
}