<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblGateAccessTable extends Migration
{
    public function up()
    {
        Schema::create('tbl_gate_access', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('tbl_user')->onDelete('cascade'); // Foreign key to tbl_user
            $table->string('access_type'); // masuk or keluar
            $table->dateTime('access_time');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tbl_gate_access');
    }
}