<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblCCTVLogTable extends Migration
{
    public function up()
    {
        Schema::create('tbl_cctv_log', function (Blueprint $table) {
            $table->id();
            $table->foreignId('cctv_id')->constrained('tbl_cctv')->onDelete('cascade'); // Foreign key to tbl_cctv
            $table->foreignId('user_id')->constrained('tbl_user')->onDelete('cascade'); // Foreign key to tbl_user
            $table->string('action'); // masuk or keluar
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tbl_cctv_log');
    }
}