<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblCCTVAreaTable extends Migration
{
    public function up()
    {
        Schema::create('tbl_cctv_area', function (Blueprint $table) {
            $table->id();
            $table->string('area_name'); // lobi, gerbang, etc.
            $table->foreignId('cctv_id')->constrained('tbl_cctv')->onDelete('cascade');
            $table->enum('status', [0, 1])->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tbl_cctv_area');
    }
}