<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblCCTVAccess extends Migration
{
    public function up()
    {
        Schema::create('tbl_cctv_access', function (Blueprint $table) {
            $table->id();
            $table->foreignId('level_id')->constrained('tbl_user_level')->onDelete('cascade'); // Foreign key to user level
            $table->foreignId('cctv_id')->constrained('tbl_cctv')->onDelete('cascade'); // Foreign key to CCTV
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tbl_cctv_access');
    }
}