<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDetectionLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_detection_logs', function (Blueprint $table) {
            $table->id(); // Primary Key
            $table->unsignedBigInteger('user_id')->nullable(); // ID of the user associated with the log
            $table->unsignedBigInteger('camera_id'); // ID of the camera associated with the log
            $table->dateTime('datetime'); // Date and time of the detection
            $table->timestamps(); // Created at and Updated at timestamps

            // Foreign key constraints
            $table->foreign('user_id')->references('id')->on('tbl_user')->onDelete('set null');
            $table->foreign('camera_id')->references('id')->on('tbl_cctv')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_detection_logs');
    }
}