<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('tbl_visitor', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Nama
            $table->string('address')->nullable(); // Alamat
            $table->string('agency')->nullable(); // Agensi/Instansi
            $table->string('met_with')->nullable(); // Bertemu dengan
            $table->string('purpose')->nullable(); // Keperluan
            $table->datetime('time_in')->nullable(); // Jam Masuk
            $table->datetime('time_out')->nullable(); // Jam Keluar
            $table->string('identity_card')->nullable(); // Kartu Identitas
            $table->string('vehicle_number')->nullable(); // Nomor Kendaraan
            $table->string('guest_card_number')->nullable(); // No Kartu Tamu
            $table->string('signature')->nullable(); // Paraf
            $table->string('note')->nullable(); // Keterangan
            $table->timestamps(); // Created_at dan updated_at
        });
    }

    public function down()
    {
        Schema::dropIfExists('tbl_visitor');
    }
};