<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateTblCctvAddIpAddressIntranetAndRemoveCategory extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tbl_cctv', function (Blueprint $table) {
            // Tambahkan kolom ip_address_intranet setelah ip_address
            $table->string('ip_address_intranet')->nullable()->after('ip_address');

            // Hapus kolom category
            $table->dropColumn('category');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tbl_cctv', function (Blueprint $table) {
            // Hapus kolom ip_address_intranet jika rollback
            $table->dropColumn('ip_address_intranet');

            // Tambahkan kembali kolom category jika rollback
            $table->string('category')->nullable();
        });
    }
}
