<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class CCTVSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('tbl_cctv')->truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        $currentTimestamp = Carbon::now(); // Timestamp saat ini

        $cctvs = [
            [
                'camera_id' => 1,
                'camera_name' => 'CCTV 1 - Ruang K3KL',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_1/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_1/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1, // Ganti dengan ID building yang sesuai
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
            [
                'camera_id' => 2,
                'camera_name' => 'CCTV 2 - Ruang Perencanaan',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_2/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_2/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1,
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
            [
                'camera_id' => 3,
                'camera_name' => 'CCTV 3 - Ruang Distribusi',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_3/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_3/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1,
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
            [
                'camera_id' => 4,
                'camera_name' => 'CCTV 4 - Ruang Distribusi dan Perencanaan',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_4/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_4/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1,
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
            [
                'camera_id' => 5,
                'camera_name' => 'CCTV 5 - Lorong Distribusi',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_5/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_5/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1,
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
            [
                'camera_id' => 6,
                'camera_name' => 'CAMERA 6',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_6/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_6/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1,
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
            [
                'camera_id' => 7,
                'camera_name' => 'CAMERA POS 1 - ALPR CAR',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_pos_1_alpr_car/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_pos_1_alpr_car/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1,
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
            [
                'camera_id' => 8,
                'camera_name' => 'CAMERA POS 1 - FACE CAR',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_pos_1_face_car/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_pos_1_face_car/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1,
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
            [
                'camera_id' => 9,
                'camera_name' => 'CAMERA POS 1 - FACE BIKE',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_pos_1_face_bike/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_pos_1_face_bike/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1,
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
            [
                'camera_id' => 10,
                'camera_name' => 'CAMERA 10',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_10/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_10/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1,
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
            [
                'camera_id' => 11,
                'camera_name' => 'CAMERA POS 2 - ALPR CAR',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_pos_2_alpr_car/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_pos_2_alpr_car/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1,
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
            [
                'camera_id' => 12,
                'camera_name' => 'CAMERA POS 2 - FACE CAR',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_pos_2_face_car/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_pos_2_face_car/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1,
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
            [
                'camera_id' => 13,
                'camera_name' => 'CAMERA POS 2 - FACE BIKE',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_pos_2_face_bike/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_pos_2_face_bike/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1,
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
            [
                'camera_id' => 14,
                'camera_name' => 'CAMERA 14',
                'ip_address' => 'https://cctvpln.bantungoding.com/camera_14/mjpeg-streams/my_stream',
                'ip_address_intranet' => 'http://192.168.1.76:8888/camera_14/mjpeg-streams/my_stream',
                'resolution' => null,
                'building_id' => 1,
                'status' => 1,
                'created_at' => $currentTimestamp,
                'updated_at' => $currentTimestamp,
            ],
        ];

        DB::table('tbl_cctv')->insert($cctvs);
    }
}