<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Load Excel file
        $filePath = base_path('database/seeders/data_user.xlsx');
        $data = Excel::toArray([], $filePath);

        // Extract the relevant sheet (assuming it's the first sheet)
        $rows = $data[0];

        $users = [];

        foreach ($rows as $index => $row) {
            if ($index === 0) continue; // Skip header row

            $name = $row[1];
            if (empty($name) || is_null($name)) continue; // Skip if name is empty or null

            $position = $row[2];

            $username = strtolower(str_replace(' ', '.', $name));
            $levelId = str_contains(strtoupper($position), 'MANAGER') ? 3 : 5;

            $users[] = [
                'level_id' => $levelId,
                'username' => $username,
                'nama_lengkap' => $name,
                'email' => $username . '@pln.co.id',
                'no_hp' => '0',
                'password' => Hash::make('password'),
                'nip' => '00000000',
                'jabatan' => $position,
                'token_reset_password' => null,
                'last_login' => now(),
                'status' => '1',
                'created_at' => now(),
                'updated_at' => now(),
            ];
        }

        DB::table('tbl_user')->insert($users);
    }
}