import {
    createApp
} from 'vue';
import router from '@/router/router';
import App from '@/App.vue';
import VueSweetalert2 from 'vue-sweetalert2';
import 'sweetalert2/dist/sweetalert2.min.css';
import store from '@/router/store.js';

// Create Vue app
const app = createApp(App);

app.use(VueSweetalert2);
app.use(store);
app.use(router);
app.mount('#app');

// Listen to route changes
document.addEventListener('route-changed', event => {
    document.getElementById('route-name').textContent =
        event.detail + ' | CCTV STREAM - PT. PLN PERSERO';
});

if ('serviceWorker' in navigator) {
    window.addEventListener('load', () => {
        navigator.serviceWorker.register('/build/sw.js').then(registration => {
            console.log('ServiceWorker registration successful with scope: ', registration.scope);
        }, err => {
            console.log('ServiceWorker registration failed: ', err);
        });
    });
}

let deferredPrompt;
const addBtn = document.getElementById('a2hs-button');
window.addEventListener('beforeinstallprompt', (e) => {
    console.log('beforeinstallprompt event triggered');
    e.preventDefault();
    deferredPrompt = e;
    addBtn.style.display = 'block';
    console.log('Prompt stored and button displayed');

    addBtn.addEventListener('click', () => {
        addBtn.style.display = 'none';
        deferredPrompt.prompt();
        deferredPrompt.userChoice.then((choiceResult) => {
            if (choiceResult.outcome === 'accepted') {
                console.log('User accepted the A2HS prompt');
            } else {
                console.log('User dismissed the A2HS prompt');
            }
            deferredPrompt = null;
        });
    });
});
