import axios from 'axios'
import router from '../router' // Sesuaikan path router sesuai dengan struktur proyek Anda

axios.interceptors.response.use(
    response => {
        return response
    },
    error => {
        const {
            status
        } = error.response
        if (status === 401) {
            localStorage.removeItem('authToken')
            router.push('/login')
        }
        return Promise.reject(error)
    }
)

export default axios
