import mqtt from 'mqtt';

const options = {
    host: '103.145.126.158',
    port: 9001,
    path: '/mqtt',
    username: 'user1',
    password: 'user1',
    protocol: 'wss'
};

const client = mqtt.connect(`wss://${options.host}:${options.port}${options.path}`, {
    username: options.username,
    password: options.password
});

client.on('connect', function () {
    console.log('Connected to MQTT broker');

    client.subscribe('#', function (err) {
        if (!err) {
            console.log('Subscribed to #');
        }
    });
});

client.on('message', function (topic, message) {
    // console.log(`Message received on ${topic}: ${message.toString()}`);
    console.log(`Message received on ${topic}`);
});

export default client;
