import {
    createRouter,
    createWebHistory
} from 'vue-router'
import store from './store.js'

const routes = [{
        path: '/',
        name: 'Home',
        component: () => import('@/views/portal/home/index.vue')
    },
    {
        path: '/faq',
        name: 'FAQ',
        component: () => import('@/views/portal/faq/index.vue')
    },
    {
        path: '/tentang',
        name: 'Tentang',
        component: () => import('@/views/portal/tentang/index.vue')
    },
    {
        path: '/privacy-policy',
        name: 'Privacy Policy',
        component: () => import('@/views/portal/privacy-policy/index.vue')
    },
    {
        path: '/account-deletion',
        name: 'Account Deletion',
        component: () => import('@/views/portal/account-deletion/index.vue')
    },
    {
        path: '/login',
        name: 'Login',
        component: () => import('@/views/manage/auth/login.vue')
    },
    {
        path: '/dashboard',
        name: 'Dashboard',
        component: () => import('@/views/manage/dashboard/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
        }
    },
    {
        path: '/manage/cctv-multiple-stream/:officeId',
        name: 'Multiple CCTV Stream',
        component: () => import('@/views/manage/cctv-multiple-stream/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
        }
    }, {
        path: '/manage/cctv-single-stream/:officeId',
        name: 'Single CCTV Stream',
        component: () => import('@/views/manage/cctv-single-stream/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
        }
    },
    {
        path: '/manage/live-monitoring-project',
        name: 'Live Monitoring Project',
        component: () => import('@/views/manage/live-monitoring-project/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3]
        }
    },

    {
        path: '/manage/subject-label-ai',
        name: 'Subject / Label AI',
        component: () => import('@/views/manage/subject-label-ai/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1]
        }
    },
    {
        path: '/manage/face-collection',
        name: 'Face Collection',
        component: () => import('@/views/manage/face-collection/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
        }
    },
    {
        path: '/manage/person-detection-logs',
        name: 'Person Detection Logs',
        component: () => import('@/views/manage/person-detection-logs/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 4, 7]
        }
    },
    {
        path: '/manage/security-patrol-logs',
        name: 'Security Patrol Logs',
        component: () => import('@/views/manage/security-patrol-logs/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 4, 7]
        }
    },
    {
        path: '/manage/plate-number-detection-logs',
        name: 'Plate Number Detection Logs',
        component: () => import('@/views/manage/plate-number-detection-logs/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 4, 7]
        }
    },
    {
        path: '/manage/realtime-detection',
        name: 'Realtime Detection',
        component: () => import('@/views/manage/realtime-detection/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
        }
    },
    {
        path: '/manage/list-unknown-people',
        name: 'List Unknown People',
        component: () => import('@/views/manage/list-unknown-people/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 4, 7]
        }
    },
    {
        path: '/manage/manajemen-data/plate-number',
        name: 'Manajemen Data Plate Number',
        component: () => import('@/views/manage/manajemen-data/plate-number/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 4, 7]
        }
    },
    {
        path: '/manage/manajemen-data/users',
        name: 'Manajemen Data Users',
        component: () => import('@/views/manage/manajemen-data/users/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 4, 7]
        }
    },
    {
        path: '/manage/manajemen-data/cctv',
        name: 'Manajemen Data CCTV',
        component: () => import('@/views/manage/manajemen-data/cctv/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 7]
        }
    },
    {
        path: '/manage/manajemen-data/cctv-live-monitoring-project',
        name: 'Manajemen Data CCTV Live Monitoring Project',
        component: () => import('@/views/manage/manajemen-data/cctv-live-monitoring-project/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3]
        }
    },
    {
        path: '/manage/manajemen-data/office',
        name: 'Manajemen Data Office',
        component: () => import('@/views/manage/manajemen-data/office/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 7]
        }
    },
    {
        path: '/manage/manajemen-data/building',
        name: 'Manajemen Data Building',
        component: () => import('@/views/manage/manajemen-data/building/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 7]
        }
    },
    {
        path: '/manage/manajemen-data/cctv-area',
        name: 'Manajemen Data CCTV Area',
        component: () => import('@/views/manage/manajemen-data/cctv-area/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 7]
        }
    },
    {
        path: '/manage/pengaturan',
        name: 'Pengaturan',
        component: () => import('@/views/manage/pengaturan/index.vue'),
        meta: {
            requiresAuth: true,
            roles: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
        }
    },
    {
        path: '/:pathMatch(.*)*',
        name: 'Page Not Found',
        component: () => import('@/views/not-found.vue')
    }
]

const router = createRouter({
    history: createWebHistory(),
    routes
})

router.afterEach(to => {
    const event = new CustomEvent('route-changed', {
        detail: to.name
    })
    document.dispatchEvent(event)
    console.log('Navigated to:', to.name);
})

router.beforeEach((to, from, next) => {
    store.dispatch('checkAuth')

    if (to.matched.some(record => record.meta.requiresAuth)) {
        if (!store.getters.isAuthenticated) {
            next({
                name: 'Login'
            })
        } else {
            const user = store.getters.user
            const userRoleId = parseInt(user.level_id, 10)
            if (to.meta.roles && !to.meta.roles.includes(userRoleId)) {
                next({
                    name: 'Home'
                })
            } else {
                if (
                    ['Multiple CCTV Stream', 'Single CCTV Stream'].includes(to.name) &&
                    !to.params.officeId
                ) {
                    console.error('Terjadi kesalahan !');
                    next({
                        name: 'Dashboard'
                    });
                } else {
                    next();
                }
            }
        }
    } else {
        next()
    }
})

export default router
