<?php

use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\AuthMobileController;
use App\Http\Controllers\API\BuildingController;
use App\Http\Controllers\API\CctvAreaController;
use App\Http\Controllers\API\CctvController;
use App\Http\Controllers\API\CctvLiveMonitoringProjectController;
use App\Http\Controllers\API\CCTVMobileController;
use App\Http\Controllers\API\ClickHouseController;
use App\Http\Controllers\API\DashboardController;
use App\Http\Controllers\API\OfficeController;
use App\Http\Controllers\API\OfficeMobileController;
use App\Http\Controllers\API\PlateNumberController;
use App\Http\Controllers\API\PlateNumberMobileController;
use App\Http\Controllers\API\RoleController;
use App\Http\Controllers\API\UserController;
use App\Http\Controllers\API\UserMobileController;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Route;

// API WEB

Route::post('login', [AuthController::class, 'login']);
Route::post('refresh-token', [AuthController::class, 'refreshToken']);
// Route::get('/v2/sensors/log-object-detected', [ClickHouseController::class, 'getObjectNameDetected']);
// Route::get('/v2/sensors/log-plat-number-detected', [ClickHouseController::class, 'getPlateNumberDetected']);

Route::middleware(['jwt.auth'])->group(function () {
    Route::post('logout', [
        AuthController::class,
        'logout',
    ]);
    Route::post('dashboard-counts', [DashboardController::class, 'getCounts']);

    Route::post('/v1/sensors/log-object-detected', [ClickHouseController::class, 'getObjectNameDetected']);
    Route::post('/v1/sensors/log-plat-number-detected', [ClickHouseController::class, 'getPlateNumberDetected']);
    Route::post('/v1/sensors/log-security-patrol', [ClickHouseController::class, 'getSecurityPatrolDetected']);

    // Summary
    Route::post('/v1/sensors/all-detection-summary', [ClickHouseController::class, 'getAllDetectionSummary']);
    Route::post('/v1/sensors/object-detection-summary', [ClickHouseController::class, 'getObjectDetectionSummary']);
    Route::post('/v1/sensors/plate-number-summary', [ClickHouseController::class, 'getPlateNumberSummary']);
    Route::post('/v1/sensors/security-patrol-detection-summary', [ClickHouseController::class, 'getSecurityPatrolDetectionSummary']);

    Route::get('user', [AuthController::class, 'getUser']);

    Route::get('/users/list', [UserController::class, 'getUserList']);
    Route::apiResource('users', UserController::class);
    Route::put('users/{id}/profile', [UserController::class, 'changeProfile']);
    Route::put('users/{id}/password', [UserController::class, 'changePassword']);
    Route::put('users/{id}/activate', [UserController::class, 'activateAccount']);
    Route::put('users/{id}/deactivate', [UserController::class, 'deactivateAccount']);
    Route::get('users/options', [UserController::class, 'listOptions']);

    Route::get('/roles/list', [RoleController::class, 'getRoleList']);
    Route::get('/roles/update-user/list', [RoleController::class, 'getRoleToUpdateUserList']);
    Route::apiResource('roles', RoleController::class);

    Route::get('cctv/streams', [CctvController::class, 'getListCctvStreams']);
    Route::get('cctv/streams/all', [CctvController::class, 'getListAllCctvStreams']);

    Route::apiResource('cctvs', CctvController::class);
    Route::apiResource('cctv-live-monitoring-project', CctvLiveMonitoringProjectController::class);

    Route::get('/cctv-areas', [CctvAreaController::class, 'index']);
    Route::post('/cctv-areas', [CctvAreaController::class, 'store']);
    Route::put('/cctv-areas/{id}', [CctvAreaController::class, 'update']);
    Route::delete('/cctv-areas/{id}', [CctvAreaController::class, 'destroy']);

    Route::get('/buildings/list', [BuildingController::class, 'getListBuildings']);
    Route::get('/buildings', [BuildingController::class, 'index']);
    Route::post('/buildings', [BuildingController::class, 'store']);
    Route::put('/buildings/{id}', [BuildingController::class, 'update']);
    Route::delete('/buildings/{id}', [BuildingController::class, 'destroy']);

    Route::get('/offices/list', [OfficeController::class, 'getOfficeList']);
    Route::get('/office/building-grouped-by-office', [OfficeController::class, 'buildingGroupedByOffice']);
    Route::apiResource('offices', OfficeController::class);

    Route::apiResource('plate-numbers', PlateNumberController::class);
    Route::post('plate-numbers/user-by-plate', [PlateNumberController::class, 'getUserByPlateNumber']);

});

// API WEB

// API MOBILE
// USERS API
Route::post('mobile/login', [AuthMobileController::class, 'login']);
Route::post('mobile/change-password', [AuthMobileController::class, 'changePassword']);
Route::post('mobile/get-user-by-token', [AuthMobileController::class, 'getUserByToken']);
Route::post('mobile/get-user-by-id', [AuthMobileController::class, 'getUserById']);
Route::get('mobile/get-all-active-users', [AuthMobileController::class, 'getAllActiveUsers']);

// USER MOBILE
Route::put('mobile/update-user', [UserMobileController::class, 'updateUser']);

// OFFICE
Route::get('mobile/offices', [OfficeMobileController::class, 'getAllOffices']);
Route::post('mobile/offices', [OfficeMobileController::class, 'createOffice']);
Route::put('mobile/offices/{id}', [OfficeMobileController::class, 'updateOffice']);
Route::delete('mobile/offices/{id}', [OfficeMobileController::class, 'deleteOffice']);

// PLATE NUMBER
Route::post('mobile/get-all-plate-numbers', [PlateNumberMobileController::class, 'getListAllPlateNumber']);
Route::post('mobile/add-plate-number', [PlateNumberMobileController::class, 'addPlateNumber']);
Route::put('mobile/update-plate-number', [PlateNumberMobileController::class, 'updatePlateNumber']);
Route::delete('mobile/delete-plate-number', [PlateNumberMobileController::class, 'deletePlateNumber']);
Route::get('mobile/get-plate-numbers-by-user', [PlateNumberMobileController::class, 'getPlateNumbersByUser']);
Route::post('mobile/validate-plate-number', [PlateNumberMobileController::class, 'validatePlateNumber']);

// CCTV Mobile API
Route::get('mobile/cctvs', [CCTVMobileController::class, 'index']); // List all CCTVs
Route::get('mobile/cctvs/{id}', [CCTVMobileController::class, 'show']); // Show CCTV details
Route::post('mobile/cctvs', [CCTVMobileController::class, 'store']); // Add new CCTV
Route::put('mobile/cctvs/{id}', [CCTVMobileController::class, 'update']); // Update CCTV
Route::delete('mobile/cctvs/{id}', [CCTVMobileController::class, 'destroy']); // Delete CCTV
// Get CCTVs by Office ID
Route::get('mobile/cctvs/by-office/{officeId}', [CCTVMobileController::class, 'getCCTVsByOffice']);

// END API MOBILE

Route::get('/photos', function () {
    $response = Http::get('https://unknownface.bantungoding.com/photos/');
    return $response->body();
});

Route::get('/proxy/object-detected', function () {
    try {
        $response = Http::get('https://mqtt-api.bantungoding.com/object-detected');
        return response()->json($response->json(), $response->status());
    } catch (\Exception $e) {
        return response()->json(['error' => 'Failed to fetch data'], 500);
    }
});

// List subject / label AI
Route::get('/api-cpf/subjects', function () {
    $response = Http::withHeaders([
        'x-api-key' => '9115e6b4-f105-4d78-8bf3-718768d4eb48',
    ])->get('https://api-cpf.bantungoding.com/api/v1/recognition/subjects');

    return $response->json();
});

// Proxy untuk list wajah
Route::get('/api-cpf/faces', function () {
    $params = request()->query(); // Ambil query parameters dari request
    $response = Http::withHeaders([
        'x-api-key' => '9115e6b4-f105-4d78-8bf3-718768d4eb48',
    ])->get('https://api-cpf.bantungoding.com/api/v1/recognition/faces', $params);

    return $response->json();
});

// Proxy untuk gambar wajah
Route::get('/api-cpf/faces/{imageId}/img', function ($imageId) {
    $response = Http::withHeaders([
        'x-api-key' => '9115e6b4-f105-4d78-8bf3-718768d4eb48',
    ])->get("https://api-cpf.bantungoding.com/api/v1/recognition/faces/{$imageId}/img");

    return response($response->body())->header('Content-Type', $response->header('Content-Type'));
});

// Untuk tambah atau update data wajab
Route::post('/api-cpf/faces', function () {
    $response = Http::withHeaders([
        'x-api-key' => '9115e6b4-f105-4d78-8bf3-718768d4eb48',
    ])->attach(
        'file',
        request()->file('file')->get(),
        request()->file('file')->getClientOriginalName()
    )->post('https://api-cpf.bantungoding.com/api/v1/recognition/faces', [
        'subject' => request('subject'),
    ]);

    return $response->json();
});

// download atau lihat gambar wajah
Route::get('/proxy/download', function () {
    $fileUrl = request('url'); // URL file yang diterima dari frontend

    $response = Http::get($fileUrl);

    if ($response->failed()) {
        return response()->json(['message' => 'Failed to download file'], 500);
    }

    return response($response->body(), 200, [
        'Content-Type' => $response->header('Content-Type'),
    ]);
});

// Delete gambar wajah
Route::delete('/api-cpf/faces/{imageId}', function ($imageId) {
    $response = Http::withHeaders([
        'x-api-key' => '9115e6b4-f105-4d78-8bf3-718768d4eb48',
    ])->delete("https://api-cpf.bantungoding.com/api/v1/recognition/faces/{$imageId}");

    return $response->json();
});

// Add atau update data wajah
Route::post('/api-cpf/subjects', function () {
    $subjectName = request('subject'); // Ambil subject dari body request

    if (!$subjectName) {
        return response()->json(['error' => 'Subject name is required.'], 400);
    }

    $response = Http::withHeaders([
        'x-api-key' => '9115e6b4-f105-4d78-8bf3-718768d4eb48', // Ganti dengan API Key yang valid
    ])->post('https://api-cpf.bantungoding.com/api/v1/recognition/subjects', [
        'subject' => $subjectName,
    ]);

    if ($response->failed()) {
        return response()->json(['error' => 'Failed to add subject.'], $response->status());
    }

    return $response->json(); // Kirimkan respon dari API eksternal
});

// Rename subject
Route::put('/api-cpf/subjects/{subject}', function ($subject) {
    $response = Http::withHeaders([
        'x-api-key' => '9115e6b4-f105-4d78-8bf3-718768d4eb48',
    ])->put("https://api-cpf.bantungoding.com/api/v1/recognition/subjects/{$subject}", [
        'subject' => request('subject'),
    ]);

    return $response->json();
});

// Delete subject
Route::delete('/api-cpf/subjects/{subject}', function ($subject) {
    $response = Http::withHeaders([
        'x-api-key' => '9115e6b4-f105-4d78-8bf3-718768d4eb48',
    ])->delete("https://api-cpf.bantungoding.com/api/v1/recognition/subjects/{$subject}");

    return $response->json();
});

// routes/api.php
Route::get('/hls/{any}', function ($any) {
    $url = "https://streamyantex.bantungoding.com/hls/" . $any;
    return redirect()->away($url);
})->where('any', '.*');

Route::get('/proxy-hls/{file}', function ($file) {
    $url = "https://live-hls-abr-cdn.livepush.io/live/bigbuckbunnyclip/{$file}";
    $response = Http::withHeaders([
        'User-Agent' => 'Mozilla/5.0',
        'Referer' => 'https://cctv.uidkalbar.com', // spoof referer
    ])->get($url);

    return response($response->body(), $response->status())
        ->header('Content-Type', $response->header('Content-Type'))
        ->header('Access-Control-Allow-Origin', '*');
});
