import {
    defineConfig
} from 'vite';
import laravel from 'laravel-vite-plugin';
import vue from '@vitejs/plugin-vue';
import {
    VitePWA
} from 'vite-plugin-pwa';

export default defineConfig({
    optimizeDeps: {
        include: ["jquery", "select2", "video.js", "@silvermine/videojs-quality-selector", "videojs-http-source-selector"],
    },
    ssr: {
        noExternal: ["@silvermine/videojs-quality-selector"],
    },
    plugins: [
        laravel({
            input: ['resources/css/app.css', 'resources/js/app.js'],
            buildDirectory: 'build',
            refresh: true,
        }),
        vue({
            template: {
                transformAssetUrls: {
                    base: null,
                    includeAbsolute: false,
                },
            },
        }),
        VitePWA({
            strategies: 'generateSW',
            registerType: 'autoUpdate',
            manifest: {
                name: "Aplikasi CCTV",
                short_name: "CCTV APP",
                start_url: "/",
                display: "standalone",
                background_color: "#ffffff",
                theme_color: "#4DBA87",
                description: "Aplikasi CCTV",
                icons: [{
                        src: "https://cctv.uidkalbar.com/assets/img/logo.png",
                        sizes: "192x192",
                        type: "image/png"
                    },
                    {
                        src: "https://cctv.uidkalbar.com/assets/img/logo.png",
                        sizes: "512x512",
                        type: "image/png"
                    }
                ]
            },
            workbox: {
                maximumFileSizeToCacheInBytes: 5 * 1024 * 1024,
                globPatterns: ['**/*.{js,css,html,png,jpg,svg}'],
                runtimeCaching: [{
                    urlPattern: /^https:\/\/your-domain\.com\/index\.html/,
                    handler: 'StaleWhileRevalidate',
                    options: {
                        cacheName: 'html-cache',
                    },
                }],
            },
        }),
    ],
    server: {
        proxy: {
            '/api': {
                target: 'https://cctv.uidkalbar.com',
                changeOrigin: true,
                rewrite: path => path.replace(/^\/api/, ''),
            },
            '/photos': {
                target: 'https://unknownface.bantungoding.com',
                changeOrigin: true,
                rewrite: path => path.replace(/^\/photos/, '')
            },
            '/api-cpf': {
                target: 'https://api-cpf.bantungoding.com',
                changeOrigin: true,
                rewrite: (path) => path.replace(/^\/api-cpf/, ''),
            },
        },
    },
    resolve: {
        alias: {
            vue: 'vue/dist/vue.esm-bundler.js',
            '@': '/resources/js/src',
            'bootstrap': 'bootstrap'
        }
    }
});
